﻿var assignments = {
    context: $(".v-callbacks-assignments"),
    datatable: null,
    caseFilter: null,
    nbOfRecords: 0,
    totalRecords: 0,
    caseIds: null,
    initialize: function () {
        assignments.caseFilter = caseFilter.getFilterObject();

        var columns = [{ "Name": "Id", "Title": resources.Id, "Key": true },
                       { "Name": "Active", "Title": resources.Active, "ShowIcon": true, "Type": "boolean", "AdvancedFilterLabels": { "0": resources.Inactive, "1": resources.Active } }];

        if (voxco.security.hasFeature("CAN_READ_PII"))
            columns.push({ "Name": "Phone", "Title": resources.Phone });

        columns.push({ "Name": "AgentName", "Title": resources.BelongingTo },
                    { "Name": "CodeResult", "Title": resources.CaseResult },
                    { "Name": "StrataOpened", "Title": resources.Strata, "EnumType": "QuotaStatus", "Type": "enum" },
                    { "Name": "LastCallDate", "Title": resources.LastCall, "Type": "date" },
                    { "Name": "CallCount", "Title": resources.NbCalls },
                    { "Name": "Priority", "Title": resources.Priority },
                    { "Name": "DialingMode", "Title": resources.DialingMode, "EnumType": "DialingModeEnum", "Type": "enum" },
                    { "Name": "CallbackDate", "Title": resources.CallBack, "Type": "date" },
                    { "Name": "TimeSlot", "Title": resources.TimeSlot, "EnumType": "TimeSlotModeEnum", "Type": "enum" },
                    { "Name": "CyclePhoneNumber", "Title": resources.CyclePhoneNumber, "ShowIcon": true, "Type": "boolean", "AdvancedFilterLabels": { "0": resources.Disabled, "1": resources.Enabled } });

        this.datatable = $(".h-assignments-table", this.context).a4datatable({
            advancedFilter: true,
            height: "full",
            ajaxParams: { "caseFilter": assignments.caseFilter },
            ajaxAction: a4.getProjectAction("GetCasesSelection", "Callbacks"),
            columns: columns,
            stateKey: "CallbackAssignment",
            toolBarItems: [
                { "Action": "modifySelectedRespondents", "Label": resources.ModifySelected },
                { "Action": "modifyRespondents", "Label": resources.ModifyCases, "DisplayMode": dataTables.itemDisplayMode.nonSelected, "DisplayCondition": function(data){ return !assignments.datatable.a4datatable('getTableParams').IsSearch && typeof assignments.datatable.a4datatable('getTableParams').AdvancedFilter == 'undefined';} }
            ],
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                assignments.casesIds = _.map(rows, function (row) { return row.Id; });

                switch (action) {
                    case "modifySelectedRespondents":
                        modalDialog.showWindow(a4.getProjectAction("CallbackAssignmentModifySelection", "Callbacks", { type: 2, caseIds: 0 }), 600, 750, { afterClose: function () { assignments.refreshContent(); } });
                        break;
                    case "modifyRespondents":
                        modalDialog.showWindow(a4.getProjectAction("CallbackAssignmentModifySelection", "Callbacks", { type: 0, caseIds: 0 }), 600, 750, { afterClose: function () { assignments.refreshContent(); } });
                        break;
                }
            },
            contextMenuItems: [
                { "Action": "modifyRespondent", "Label": resources.Modify },
            ],
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "modifyRespondent":
                        assignments.casesIds = [row.Id];
                        modalDialog.showWindow(a4.getProjectAction("CallbackAssignmentModifySelection", "Callbacks", { type: 1, caseIds: row.Id }), 600, 750, { afterClose: function () { assignments.refreshContent(); } });
                        break;
                }
            },
            draw: function () {
                assignments.nbOfRecords = parseInt($(this).a4datatable("getDisplayedRecords"), 10);
                assignments.totalRecords = parseInt($(this).a4datatable("getTotalRecords"), 10);
            },
            localizableTexts: { "Search": resources.SearchCases }
        });
    },
    bindEvents: function () {
        this.context.on("click", ".h-callbackAssignmentHistory", function () {
            modalDialog.showWindow(a4.getProjectAction("CallbackAssignmentHistory", "Callbacks"), 650, 950);
        });

        this.context.on("click", ".h-Browse", function () {
            window.location = a4.getProjectAction("Browse", "Data");
        });

        this.context.on("click", ".section-header, .v-createFilterMessage", function () {
            var sectionBox = $(this).closest(".section-box");
            assignments.toggleCaseFilter(sectionBox);
        });

        this.context.on("click", ".h-applyFilter", function () {
            caseFilter.getCaseFilter(function (filter, summary) {
                $(".v-caseFilterSummary", assignments.context).html(summary);

                if (filter.IsValid) {
                    assignments.caseFilter = filter;
                    assignments.datatable.a4datatable("option", "ajaxParams", { "caseFilter": filter });
                    assignments.datatable.a4datatable("refresh", true, true);
                }
            });
        });

        this.context.on("click", ".h-clearFilter", function () {
            caseFilter.clearCaseFilter();
            caseFilter.initializeCaseFilterAutoComplete();

            if (assignments.caseFilter)
                assignments.caseFilter = null;

            $(".v-caseFilterSummary", assignments.context).html("");
            assignments.datatable.a4datatable("option", "ajaxParams", { "caseFilter": null });
            assignments.datatable.a4datatable("refresh", true, true);

            var sectionBox = $(this).closest(".section-box");

            if (!$(".section-content", sectionBox).is(":visible")) {
                $(".v-createFilterMessage", sectionBox).show();
                $(".buttons", sectionBox).hide();
            }

        });

        $(".h-exportRespondents").on("click", function () {
            var columns = assignments.datatable.a4datatable("getVisibleColumns");
            var tableParams = assignments.datatable.a4datatable("getTableParams");

            var params = {
                tableParams: JSON.stringify(tableParams),
                caseFilter: (assignments.caseFilter) ? assignments.caseFilter : caseFilter.getFilterObject(),
                columns: columns.join()
            };

            a4.showBusyBox();

            a4.callServerMethod(a4.getProjectAction("ExportRespondents", "CallBacks"), params,
                function (result) {
                    a4.hideBusyBox();
                    window.location = a4.getProjectAction("GetRespondentsFile", "CallBacks", { filePath: result, fileName: "CallbackAssignment.xlsx" });
                });
        });
    },
    refreshContent: function () {
        this.datatable.a4datatable("refresh", true, true);
    },
    applySelection: function (interviewerIds, changeDate, changeTime, projectId, modificationType, priorityValue, priorityType, timeSlotStatus, dialingMode, cyclePhoneNumber, caseFilters) {
        var model = {};

        if (!caseFilters)
            assignments.caseFilter = caseFilter.getFilterObject();

        model.CaseFilter = assignments.caseFilter;
        model.CaseIds = assignments.casesIds;
        model.InterviewerIds = interviewerIds;
        model.ChangeDate = changeDate;
        model.ChangeTime = changeTime;
        model.ProjectId = projectId;
        model.ModificationType = modificationType;
        model.PriorityValue = priorityValue;
        model.PriorityType = priorityType;
        model.TimeSlotStatus = timeSlotStatus;
        model.DialingMode = dialingMode;
        model.CyclePhoneNumber = cyclePhoneNumber;

        return a4.callServerMethod(a4.getProjectAction("ApplySelection", "CallBacks"), { assignment: model },
            function (result) {
                var message = NbrOfRecordAssignedResources["Message"];
                message = message.replace(/{(.*?)}/g, result.Count);
                a4.showSuccessMessage(message);
                assignments.datatable.a4datatable("option", "ajaxParams", { "caseFilter": model.CaseFilter });
                assignments.datatable.a4datatable("refresh", true, true);
                assignments.casesIds = null;
            }, null, { blockElement: caseFilter.context });
    },
    toggleCaseFilter: function (sectionBox) {
        sectionBox.find(".section-header .fa").toggleClass("fa-caret-down fa-caret-right");
        $(".section-content", sectionBox).toggle();

        if ($(".section-content", sectionBox).is(":visible") || assignments.caseFilter) {
            $(".v-createFilterMessage", sectionBox).hide();
            $(".buttons", sectionBox).show();
        }
        else {
            $(".v-createFilterMessage", sectionBox).show();
            $(".buttons", sectionBox).hide();
        }

        //To trigger datatable adjust height
        $(window).trigger("resize");
    }
};

$(document).ready(function () {
    if (assignments.context.length > 0) {
        assignments.initialize();
        assignments.bindEvents();
    }
});